#include "ScnFileOp.h"
#include "copythread.h"
#include "scnutilities.h"

string CD_Source;
string CD_Dest;
CD_ActionNames CD_Action;
bool CD_Done = false;

//string CD_DestTitle;

CCopyThread * ct = NULL;

HRESULT CScnFileOp::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	DebugMsg("CScnFileOp::OnInit");
	Completed = false;

    GetChildById( L"From", &m_from );
    GetChildById( L"To", &m_to );
    GetChildById( L"CurrentFile", &m_curfile );
    GetChildById( L"Sub1Progress", &m_sub1pb );
    GetChildById( L"Sub2Progress", &m_sub2pb );
    GetChildById( L"Stats", &m_stats );
    GetChildById( L"BackButton", &m_cancel );
    GetChildById( L"Title", &m_title );

	if (IsFolder(CD_Source))
		CD_Source.append("\\");
	CD_Source = str_replaceallA(CD_Source,"\\\\","\\");

	if (IsFolder(CD_Dest))
		CD_Dest.append("\\");
	CD_Dest = str_replaceallA(CD_Dest,"\\\\","\\");

	m_from.SetText(strtowstr("From: " + CD_Source).c_str());
	m_to.SetText(strtowstr("To: " + CD_Dest).c_str());

	if (ct)
		delete ct;

	ct = new CCopyThread();
	ct->Source = CD_Source;
	ct->Dest = CD_Dest;
	ct->Action = CD_Action;
	//ct->Source = "usb0:\\test\\";
	//ct->Dest = "usb0:\\test2\\";

	switch (CD_Action)
	{
	case CDA_COPYDVD:
		m_title.SetText(L"Copying DVD to hard drive");
		break;
	case CDA_MOVEFILES:
	case CDA_SDMODE:
		m_title.SetText(L"Moving files");
		break;
	case CDA_COPYFILES:
		m_title.SetText(L"Copying files");
		break;
	case CDA_DELETE:
		m_title.SetText(L"Deleting files");
		break;
	}

	BytesLastTick.QuadPart = 0;
	BytesPerSec.QuadPart = 0;

	ct->CreateThread();

	SetTimer(TM_COPYPROGRESS,50);
	SetTimer(TM_COPYSPEED,1000);

	return S_OK;
}

HRESULT CScnFileOp::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (hObjPressed == m_cancel)
	{
		ct->Cancel = true;
		bHandled = TRUE;
	}
	return S_OK;
} 

void CScnFileOp::DisplayResult(string & result)
{
	string action = "Copied";
	if (CD_Action == CDA_MOVEFILES)
		action = "Moved";
	if (CD_Action == CDA_SDMODE)
		action = "Moved";
	if (CD_Action == CDA_DELETE)
		action = "Deleted";

	result.append(sprintfaA("%s:\n%d of %d files\n",action.c_str(),ct->Total_FilesCopied,ct->Total_Files));
	if (CD_Action != CDA_SDMODE || CD_Action == CDA_DELETE)
		result.append(sprintfaA("%0.1fMb of %0.1fMb\n",(float)(ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->Total_Size.QuadPart)/(1024.0f*1024.0f)));
	result.append("\n\n");
	result.append("Please Note: You will need to restart Freestyle for newly copied games to appear.");
}

HRESULT CScnFileOp::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_COPYPROGRESS:
			{
				if (ct->Stage == CS_CANCEL)
				{
					KillTimer(TM_COPYPROGRESS);
					Completed = true;
					memset(&overlapped,0,sizeof(overlapped));
					string result = "File Copy has been cancelled\n\n";
					DisplayResult(result);
					XShowMessageBoxUI(0,L"Transfer Cancelled",strtowstr(result).c_str(),1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
					SetTimer(TM_OVERLAPPED,50);

				} else if (ct->Stage == CS_DONE)
				{
					KillTimer(TM_COPYPROGRESS);
					Completed = true;
					memset(&overlapped,0,sizeof(overlapped));
					string result = "File Copy has been completed\n\n";
					DisplayResult(result);
					XShowMessageBoxUI(0,L"Transfer Completed",strtowstr(result).c_str(),1,btnOk,0,XMB_NOICON,&mbresult,&overlapped);
					SetTimer(TM_OVERLAPPED,50);
				}

				LARGE_INTEGER ETA;
				ETA.QuadPart = 0;
				if (BytesPerSec.QuadPart > 0)
				{
					ETA.QuadPart = ct->Total_Size.QuadPart / BytesPerSec.QuadPart;
				}
				int Hours = (int)ETA.QuadPart / 3600;
				ETA.QuadPart = (int)ETA.QuadPart % 3600;
				int Mins = (int)ETA.QuadPart / 60;
				ETA.QuadPart = ETA.QuadPart % 60;
				int Secs = (int)ETA.QuadPart;


				string progess;
				if (CD_Action == CDA_SDMODE || CD_Action == CDA_DELETE)
				{
					progess = sprintfaA("%d of %d Files",ct->Total_FilesCopied,ct->Total_Files);
				} else {
					progess = sprintfaA("%d of %d Files, %0.1fMb of %0.1fMb, %0.1fMb/s, ETA %d:%02d:%02d",ct->Total_FilesCopied,ct->Total_Files,(float)(ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->Total_Size.QuadPart)/(1024.0f*1024.0f),(float)BytesPerSec.QuadPart/(1024.0f*1024.0f),Hours,Mins,Secs);
				}
				m_stats.SetText(strtowstr(progess).c_str());

				if (ct->Stage == CS_CALCSIZE)
				{
					m_curfile.SetText(L"Calculating Size...");
				} else if (ct->Stage == CS_COPYING)
				{
					string curprog;
					if (CD_Action == CDA_SDMODE || CD_Action == CDA_DELETE)
					{
						curprog = ct->GetCurFile();
					} else {
						curprog = sprintfaA("%s, %0.1fMb of %0.1fMb",ct->GetCurFile().c_str(),(float)(ct->File_Prog.QuadPart)/(1024.0f*1024.0f),(float)(ct->File_Size.QuadPart)/(1024.0f*1024.0f));
					}
					m_curfile.SetText(strtowstr(curprog).c_str());
				} else if (ct->Stage == CS_DONE)
				{
					m_curfile.SetText(L"Done");
				}

				m_sub1pb.SetRange(0,(int)ct->Total_Size.QuadPart/1024);
				m_sub1pb.SetValue((int)(ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart)/1024);

				m_sub2pb.SetRange(0,(int)ct->File_Size.QuadPart/1024);
				m_sub2pb.SetValue((int)ct->File_Prog.QuadPart/1024);
			}
			break;
		case TM_COPYSPEED:
			{
				BytesPerSec.QuadPart = ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart - BytesLastTick.QuadPart;
				BytesLastTick.QuadPart = ct->Total_Prog.QuadPart+ct->File_Prog.QuadPart;
			}
         case TM_OVERLAPPED:
			{
				// message box done
				if (Completed && XHasOverlappedIoCompleted(&overlapped))
				{
					CD_Done = true;
					KillTimer(TM_OVERLAPPED);
					CXuiScene::NavigateBack();
				}
			}
	}
    
    return( S_OK );
}
